<?php

$content = get_the_content();
$cite    = get_post_meta( get_the_ID(), 'testimonial-author', true );
$link    = get_post_meta( get_the_ID(), 'testimonial-link', true );
$title   = get_the_title();

if ( ! empty( $link ) && ! empty( $cite ) ) {
	$cite = '<a href="' . $link . '" target="_blank">' . $cite . '</a>';
}

if ( ! empty( $title ) ) {
	if ( ! empty( $cite ) ) {
		$cite = " <span class='company-name'>($cite)</span>";
	}

	$title = "<strong class='quote-title'><span class='the-title'>$title</span>$cite</strong>";
} elseif ( ! empty( $cite ) ) {
	$title = "<strong class='quote-title'>$cite</strong>";
}

$thumbnail = '';
if ( has_post_thumbnail() ) {
	$thumbnail = '<div class="quote-thumbnail">';
	$thumbnail .= get_the_post_thumbnail( get_the_ID(), 'thumbnail' );
	$thumbnail .= $title;
	$thumbnail .= '</div>';
} else {
	$content .= '<div class="only-title">' . $title . '</div>';
}

$content = '<div class="quote-content">' . $content . '</div>';

?>
<blockquote class='clearfix small simple'><?php echo $thumbnail ?><div class='quote-text'><?php echo do_shortcode( $content ) ?></div></blockquote>
