<?php
/**
 * Single Event Meta (Organizer) Template
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe-events/modules/meta/details.php
 *
 * @package TribeEventsCalendar
 * @since 4.4
 */

$organizer_ids = tribe_get_organizer_ids();
$multiple = count( $organizer_ids ) > 1;

$phone = tribe_get_organizer_phone();
$email = tribe_get_organizer_email();
$website = tribe_get_organizer_website_link();
?>

<div class="tribe-events-meta-group tribe-events-meta-group-organizer">
	<dl>
		<?php
		do_action( 'tribe_events_single_meta_organizer_section_start' );

		if ( ! $multiple ) : // only show organizer details if there is one
		?>
			<dt> <?php _e('Organizer:', 'lawyers-attorneys' ) ?> </dt>
			<dd class="tribe-organizer">
				<?php echo tribe_get_organizer_link( $organizer_ids[0] ) ?>
			</dd>
		<?php
			if ( ! empty( $phone ) ) :
				?>
				<dt>
					<?php esc_html_e( 'Phone:', 'the-events-calendar' ) ?>
				</dt>
				<dd class="tribe-organizer-tel">
					<?php echo esc_html( $phone ); ?>
				</dd>
				<?php
			endif;

			if ( ! empty( $email ) ) :
				?>
				<dt>
					<?php esc_html_e( 'Email:', 'the-events-calendar' ) ?>
				</dt>
				<dd class="tribe-organizer-email">
					<?php echo esc_html( $email ); ?>
				</dd>
				<?php
			endif;

			if ( ! empty( $website ) ) :
				?>
				<dt>
					<?php esc_html_e( 'Organizer Website:', 'lawyers-attorneys' ) ?>
				</dt>
				<dd class="tribe-organizer-url">
					<?php echo $website; ?>
				</dd>
				<?php
			endif;
		else:
			?>
			<dt> <?php _e('Organizers:', 'lawyers-attorneys' ) ?> </dt>
			<dd class="tribe-organizer">
				<?php
					$links = array();

					foreach ( $organizer_ids as $organizer ) {
						if ( ! $organizer ) {
							continue;
						}

						$links[] = tribe_get_organizer_link( $organizer );
					}

					echo implode( ', ', $links );
				?>
			</dd>
			<?php
		endif;

		do_action( 'tribe_events_single_meta_organizer_section_end' );
		?>
	</dl>
</div>
