<?php

/**
 * Blockquote shortcode handler
 *
 * @package wpv
 * @subpackage editor
 */

/**
 * class WPV_Blockquote
 */
class WPV_Blockquote {
	/**
	 * Register the shortcodes
	 */
	public function __construct() {
		add_shortcode('blockquote', array(__CLASS__, 'dispatch'));
	}

	/**
	 * Blockquote shortcode callback
	 *
	 * @param  array  $atts    shortcode attributes
	 * @param  string $content shortcode content
	 * @param  string $code    shortcode name
	 * @return string          output html
	 */
	public static function dispatch($atts, $content, $code) {
		extract(shortcode_atts(array(
			'layout' => 'slider',
			'cat' => '',
			'ids' => '',
			'autorotate' => false,
		), $atts));

		$query = array(
			'post_type' => 'testimonials',
			'orderby' => 'menu_order',
			'order' => 'DESC',
			'posts_per_page' => -1,
		);

		if(!empty($cat)) {
			$query['tax_query'] = array(
				array(
					'taxonomy' => 'testimonials_category',
					'field' => 'slug',
					'terms' => explode(',', $cat),
				)
			);
		}

		if($ids && $ids != 'null')
			$query['post__in'] = explode(',',$ids);

		$q = new WP_Query($query);

		$output = '';

		if($layout == 'slider') {
			$slides = array();

			while($q->have_posts()) {
				$q->the_post();

				$slides[] = array(
					'type' => 'html',
					'html' => self::format(),
				);
			}

			$output = wpv_shortcode_slider(array(
				'pager' => true,
				'controls' => false,
				'auto' => wpv_sanitize_bool($autorotate),
			), json_encode($slides), 'slider');
		} else {
			$output .= '<div class="blockquote-list">';

			while($q->have_posts()) {
				$q->the_post();

				$output .= self::format();
			}

			$output .= '</div>';
		}

		wp_reset_postdata();

		return $output;
	}

	private static function format() {
		ob_start();
		get_template_part( 'templates/shortcodes/blockquote' );
		return ob_get_clean();
	}
};

new WPV_Blockquote;
