<div class="row wpv-tribe-multiple-events style-<?php echo $style ?>">
	<?php foreach($events as $i => $event): ?>
		<?php setup_postdata( $GLOBALS['post'] =& $event ) ?>
		<div class="wpv-grid grid-1-<?php echo $columns ?>">
			<div class="event-wrapper">
				<?php
					$time_format = get_option('time_format');

					// display end date if it is not the same as the start date
					if ( tribe_get_start_date( $event, false, 'Y-m-d' ) !== tribe_get_end_date( $event, false, 'Y-m-d' ) ) {
						$time_format = get_option( 'date_format' ) . ' ' . $time_format;
					}

					$stime = tribe_get_start_date( $event, false, $time_format );
					$etime = tribe_get_end_date( $event, false, $time_format );
				?>
				<a href="<?php echo esc_url( tribe_get_event_link( $event ) ) ?>" title="<?php esc_attr_e('Read More', 'lawyers-attorneys') ?>">
					<div class="thumbnail">
						<?php echo get_the_post_thumbnail( $event->ID, 'portfolio-masonry-' . $columns ); // xss ok ?>
						<div class="date">
							<div class="date-inner">
								<div class="date">
									<div class="day"><?php echo tribe_get_start_date( $event, false, 'd' ) ?></div>
									<div class="month"><?php echo tribe_get_start_date( $event, false, 'F' ) ?></div>
								</div>
							</div>
						</div>
					</div>
					<h4 class="title entry-title"><?php echo $event->post_title ?></h4>
				</a>
				<div class="when-where">
					<div><?php echo wpv_shortcode_icon( array( 'name' => 'theme-clock' ) ) ?> <?php echo $stime ?> <?php if ( $stime !== $etime ) echo '&mdash; ' . $etime ?></div>
					<div><?php echo wpv_shortcode_icon( array( 'name' => 'theme-pointer' ) ) ?> <?php
						if( class_exists( 'Tribe__Events__Pro__Templates__Single_Venue' ) ) {
							echo tribe_get_venue_link( $event->ID, true );
						} else {
							echo tribe_get_venue( $event->ID );
						}
					?>
					</div>
				</div>
				<div class="description">
					<?php the_excerpt(); ?>
				</div>
			</div>
		</div>
		<?php if($i % $columns === $columns - 1 && $i < count($events) - 1): ?>
			</div>
			<div class="row wpv-tribe-multiple-events">
		<?php endif ?>
	<?php endforeach; ?>
	<?php wp_reset_postdata(); ?>
</div>

