<?php

global $post;

wp_reset_query();
$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
?>

<div class="wpv-tribe-single-media <?php if($image === false) echo 'no-image' ?>" <?php if($image): ?>style="background-image: url('<?php echo esc_attr($image[0]) ?>')"<?php endif ?>>
	<div class="limit-wrapper">
		<div class="wpv-article-paddings-x">
			<div class="wpv-single-event-schedule">
				<?php
					$time_format = get_option('time_format');

					// display end date if it is not the same as the start date
					if ( tribe_get_start_date( $post, false, 'Y-m-d' ) !== tribe_get_end_date( $post, false, 'Y-m-d' ) ) {
						$time_format = get_option( 'date_format' ) . ' ' . $time_format;
					}

					$stime = tribe_get_start_date( $post, false, $time_format );
					$etime = tribe_get_end_date( $post, false, $time_format );
				?>
				<div class="wpv-single-event-schedule-block date-price">
					<div class="date">
						<div class="date-inner">
							<div class="day"><?php echo $day ?></div>
							<div class="month"><?php echo $month ?></div>
						</div>
					</div>
					<?php if ( tribe_get_cost() ) :  ?>
						<div class="price">
							<?php echo tribe_get_cost( null, true ); ?>
						</div>
					<?php endif ?>
				</div>
				<div class="wpv-single-event-schedule-block time">
					<div>
						<?php echo wpv_shortcode_icon( array( 'name' => 'theme-clock' ) ) ?>
						<div class="text"><?php echo $stime ?>&mdash;<?php echo $etime ?></div>
					</div>
				</div>
				<div class="wpv-single-event-schedule-block address">
					<div>
						<?php echo wpv_shortcode_icon( array( 'name' => 'theme-pointer' ) ) ?>
						<div class="text"><?php
								if( class_exists( 'Tribe__Events__Pro__Templates__Single_Venue' ) ) {
									echo tribe_get_venue_link( $post->ID, true );
								} else {
									echo tribe_get_venue( $post->ID );
								}
							?>
							<br>
							<?php echo Tribe__Events__Main::instance()->fullAddress(); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>